/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iMouse AUTO_MOUSE

/////////////////////////////////////////////////////////////////////////////////

// Simple "Automatic Mouse". Simulates scanning the mouse over the full range of
// the screen with the X and Y scanning frequencies being different. TheEmu.

#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
#define MOUSE_POS   vec2((1.0+cos(iGlobalTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )

/////////////////////////////////////////////////////////////////////////////////

//inspired by http://lodev.org/cgtutor/randomnoise.html and lots of stuff from
//other shadertoy people

#define M_PI 3.1415926535897932384626433832795
#define STAR_INTENSITY 1.5
#define PLANET_AMBIENT 0.2
#define DOT_INTENSITY 0.1
#define CLOUD_DISTANCE vec2(0.05,0.05) //cloud distance
#define CLOUD_SHADOW_INTENSITY 0.3
#define ATHMOSPHERE_DIFFUSION 1. //Higher > less diffusion

#define SPECULAR_INTENSITY 0.6
#define SPECULAR_SHININESS 5.

#define EXTERNAL_HALO_GLOW .95 //between 1 and 0
#define SCALE 1.5

#define RAY_PRECISION 0.0001
const vec3 starColor = vec3(1.  ,0.9  ,0.5 );

#define USE_PROCEDURAL
#ifdef USE_PROCEDURAL
float hash( float n ) { return fract(sin(n)*43758.5453123); }
float noise( in vec3 x )
{
    vec3 p = floor(x);
    vec3 f = fract(x);
    f = f*f*(3.0-2.0*f);

    float n = p.x + p.y*157.0 + 113.0*p.z;
    return mix(mix(mix( hash(n+  0.0), hash(n+  1.0),f.x),
                   mix( hash(n+157.0), hash(n+158.0),f.x),f.y),
               mix(mix( hash(n+113.0), hash(n+114.0),f.x),
                   mix( hash(n+270.0), hash(n+271.0),f.x),f.y),f.z);
}
#else
float noise( in vec3 x )
{
    vec3 p = floor(x);
    vec3 f = fract(x);
   f = f*f*(3.0-2.0*f);

   vec2 uv = (p.xy+vec2(37.0,17.0)*p.z) + f.xy;
   vec2 rg = texture2D( noiseTexture, (uv+0.5)/256.0, -100.0 ).yx;
   return mix( rg.x, rg.y, f.z );
}
#endif

vec4 projectionOnSphere(vec2 screenPos){

    vec3 rayOrigin = vec3( 0.0, 0.0, 2.5 );
    vec3 rayDir = normalize( vec3( screenPos, -2.0 ) );

    // intersect sphere
    float b = dot(rayOrigin,rayDir);
    float c = dot(rayOrigin,rayOrigin) - 1.0;
    float h = b*b - c;

    float t = -b - sqrt(h);
    vec3 pos = rayOrigin + t*rayDir;
    if(length(pos) > SCALE)
    {
      return vec4(-pos, length(pos));
    }
    return vec4(pos, length(pos));
}

const mat3 m = mat3( 0.00,  0.80,  0.60,
                    -0.80,  0.36, -0.48,
                    -0.60, -0.48,  0.64 );

float smoothNoise(vec3 q){
   float f = 0.5000*noise( q ); q = m*q*2.01;
   f += 0.2500*noise( q ); q = m*q*2.02;
   f += 0.1250*noise( q ); q = m*q*2.03;
   f += 0.0625*noise( q ); q = m*q*2.01;
   return f;
}

#define NB_LUT 4

vec4 mapping(float dist, float min, float max, mat4 LUT, vec4 LUT_DIST){

   float distLut = (dist - min) / max;
   int i1,j;
   for(int i=0;i <NB_LUT;++i){
      j = i + 1;
      if ( j > 3 ) j = 0;
      if(distLut < LUT_DIST[j]){i1 = i;break;}
   }
   vec4 col1,col2;
   float mixVal;
   if (i1 == 0){
      col1 = LUT[0];col2 = LUT[1];
      mixVal = (distLut - LUT_DIST[0]) / (LUT_DIST[1] - LUT_DIST[0]);
   }else if(i1 == 1){
      col1 = LUT[1];col2 = LUT[2];
      mixVal = (distLut - LUT_DIST[1]) / (LUT_DIST[2] - LUT_DIST[1]);
   }else{
      col1 = LUT[2];col2 = LUT[3];
      mixVal = (distLut - LUT_DIST[2]) / (LUT_DIST[3] - LUT_DIST[2]);
   }


   //return vec4(mixVal);
   return mix(col1,col2,mixVal);

}

mat4 LAVA_COLOR  = mat4( 0.  ,0.  ,0. ,0.,
              0.6,0.1,0.1 ,1.,
              0.9 , 0.6  ,0.3,1.,
              1.  ,0.9  ,0.5 ,1.);

vec4 LAVA_COLOR_DIST = vec4(0.,0.35,0.55,1.);

vec4 getLight(vec3 position ) {

   vec3 q = position;

   #define SURFACE_DENSITY 20.
   q *= SURFACE_DENSITY;
   float f  = smoothNoise(q);

   //x,y,z period and height, width depth for noise
   float xp = 2., nh = 10., yp = 1., nw = 1., zp = 2., nd = 1.;
   float xyzVal = position.x * xp/nh +position.y*yp/nh+position.z;
   float lava = f;
   #define LAVA_NOISE 50.

   vec4 lavaColorDist = LAVA_COLOR_DIST;
// lavaColorDist[2] -= f*0.5;


   //Color mapping
   vec4 color = mapping(1. - sqrt(lava), 0.,1.,LAVA_COLOR, lavaColorDist);

   color +=  vec4(color.x*color.x*color.x,color.y*color.y*color.y, color.z*color.z*color.z,1.);
   return color;
}

void main(void)
{
   //UNIFORMS
   float ct = cos(iGlobalTime *0.1 - 2.*iMouse.x/iResolution.x);
   float st = sin(iGlobalTime *0.1 - 2.*iMouse.x/iResolution.x);

   mat4 cameraRotation = mat4(ct,0.,st,0.,
                        0.,1.,0.,0.,
                       -st,0.,ct,0.,
                        0.,0.,0.,1.);
   //START
   vec2 uv = gl_FragCoord.xy / iResolution.xy;
   float ratio = iResolution.x/iResolution.y;
   uv.x = ratio*(uv.x - 0.25) ;
   uv = uv * 2. * SCALE - 1.*SCALE ;
   //uv with modified texture coordinates

   vec4 pos3d  = projectionOnSphere(uv) * cameraRotation;
   vec3 pos = pos3d.xyz;
   vec3 N = normalize(pos3d.xyz);

   vec3 L = vec3(1.,0.,0.);
   vec3 viewvec = vec3(0.,0.,1.);
   //vec3 viewvec = vec3(vec4(0.,0.,1.,1.) * cameraRotation);

   vec2 sphereCoord = vec2(0.5+ atan(pos.z, pos.x) / 2. / M_PI, 0.5 - asin(pos.y)/M_PI );

   vec4 ground = getLight(pos);
   vec3 color = ground.xyz;
   vec4 finalColor = vec4(color, 1.0);

   float dcenter = dot(uv,uv); //from 0 to 4
   vec3 compCol = normalize(starColor);//couleur complmentaire

   float haloGradient = (2. - pos3d.w);
   if ( pos3d.w < 1. + RAY_PRECISION) {
      float mixVal = clamp(pow( dcenter, 5.) * 2.5 ,0.,1.) ;
      finalColor = mix( finalColor, vec4(compCol*4.,1.) , max(0.05, mixVal) )  ;

   }else if(pos3d.w < 2.){

         vec3 haloColor = (compCol* 3.);
         float haloVal = pow(  haloGradient * EXTERNAL_HALO_GLOW , 15.);

         finalColor = vec4(haloColor * haloVal, 1. ) ;
         //finalColor += planetWind * haloGradient;

   }else
   {
      finalColor = vec4(0.,0.,0.,1.);//starField;

   }

   mat4 LAVA_HALO_COLOR  = mat4( 0.  ,0.  ,0. ,0.,
              0.3,0.1,0.1 ,1.,
              0.9 , 0.6  ,0.3,1.,
              1.  ,0.9  ,0.5 ,1.);
   vec4 LAVA_HALO_DIST = vec4(0.,0.3,0.7,1.);
   #define haloWidth 1.1
   #define innerHaloWidth 0.5
   if(dcenter < haloWidth && dcenter > innerHaloWidth){
      float angleHaloX = dot(normalize(uv),vec2(0.,1.));
      float angleHaloY = dot(normalize(uv),vec2(1.,0.));
      vec4 posHalo = vec4(angleHaloX,angleHaloY, iGlobalTime * .02,1.);

      float lavaHaloVal = smoothNoise(posHalo.xyz*20.);

      float haloAtt = 0.5 - abs((dcenter - innerHaloWidth)/(haloWidth - innerHaloWidth) - 0.5);
      finalColor +=  mapping(lavaHaloVal*lavaHaloVal, 0., 1., LAVA_HALO_COLOR, LAVA_HALO_DIST) * haloAtt * 4.;
   }

   gl_FragColor = finalColor;

}
